class ScrollingImageLayer{
 
  private boolean _isSeamless;
  private float _speed;
  private int _imgWidth;
  
  private PImage _layerImage1;
  private PImage _layerImage2;
  
  private float _xPos1;
  private float _yPos1;
  private float _xPos2;
  private float _yPos2;
  
  
  //Constructor
  public ScrollingImageLayer(String imgName, boolean isSeamless, float xPos, float yPos, float speed, float scale){
    
   _isSeamless = isSeamless;
   _speed = speed;
   _xPos1 = xPos;
   _yPos1 = yPos;
   
   _layerImage1 = loadImage(imgName);
   _layerImage1.resize(int(_layerImage1.width * scale), int(_layerImage1.height * scale));
   _imgWidth = _layerImage1.width;

   
   if(_isSeamless){
      _layerImage2 = loadImage(imgName);
      _layerImage2.resize(int(_layerImage2.width * scale), int(_layerImage2.height * scale));
      _xPos2 = _xPos1 + _imgWidth;
      _yPos2 = yPos;
   }

  }
  
  public void display(){
   
    _xPos1 = _xPos1 - _speed;
   
    
    if(_isSeamless){
      
      _xPos2 = _xPos2 - _speed;
      
      //check if either layer should be reset
       if(_xPos2 < imageW/2 && _xPos1 < imageW/2){
          _xPos1 = _xPos2 + _imgWidth;
       }
       
       if(_xPos1 < imageW/2 && _xPos2 < imageW/2){          
          _xPos2 = _xPos1 + _imgWidth;
       }
       
       image(_layerImage2, _xPos2, _yPos2);
       
    }else{
   
       if(_xPos1 < (imageW/2)*-1){
          _xPos1 = width + imageW/2;
       }  
    }
    
    image(_layerImage1, _xPos1, _yPos1);
    
    
    
    
  }
}
